import base64
import re
from http.server import BaseHTTPRequestHandler
from socketserver import TCPServer
from urllib.parse import unquote, parse_qs, urlparse

from http.server import ThreadingHTTPServer, BaseHTTPRequestHandler


class Handler(BaseHTTPRequestHandler):

    def do_GET(self):
        """Handle http get requests, used for manifest"""
        path = self.path  # Path with parameters received from request e.g. "/manifest?id=234324"
        print('HTTP GET Request received to {}'.format(path))
        if '/manifest' not in path:
            self.send_response(404)
            self.end_headers()
            return
        try:
            # To obtain the DRM Challenge and the DRM Session ID data to make a licensed manifest request,
            # you must set the ISA property: inputstream.adaptive.pre_init_data, see Integration Wiki page
            #  challenge_base64 = unquote(self.headers['challengeB64'])
            #  sid = self.headers['sessionId']

            # Call your method to do the magic to generate DASH manifest data
            manifest_data = b'my manifest data'
            self.send_response(200)
            self.send_header('content-type', 'application/dash+xml')
            self.end_headers()
            self.wfile.write(manifest_data)
        except Exception:
            self.send_response(500)
            self.end_headers()

    def do_POST(self):
        """Handle http post requests, used for license"""
        path = self.path  # Path with parameters received from request e.g. "/license?id=234324"
        print('HTTP POST Request received to {}'.format(path))
        if '/license' not in path:
            self.send_response(404)
            self.end_headers()
            return
        try:
            print(path.replace("/license?", ""))
            params = parse_qs(urlparse(self.path).query)
            id = params.get('id')[0]
            print(id)
            # InputStream Adaptive can send some data depending by license_key settings
            # The data is splitted by "!" char
            # This example split 'challenge' and 'session id' data
            # length = int(self.headers.get('content-length', 0))
            # isa_data = self.rfile.read(length).decode('utf-8').split('!')

            # challenge = isa_data[0]
            # session_id = isa_data[1]
            # Call your method to do the magic to generate license data
            # The format type of data must be correct in according to your VOD service

            # base64.decode()
            license_data = base64.b64decode(id).decode()
            license_data = re.compile(r'{\"([^\"]+)\":\"([^\"]+)\"}').findall(license_data)[0]
            print(license_data)
            license_data = license_data[0] + ":" + license_data[1]
            print(license_data)
            self.send_response(200)
            self.end_headers()
            self.wfile.write(license_data.encode())
        except Exception as e:
            print(e)
            self.send_response(500)
            self.end_headers()


def run():
    server = ThreadingHTTPServer(('0.0.0.0', 4444), Handler)
    server.serve_forever()


run()
