import re
from urllib.parse import quote_plus

from conf.common import CommonResolver


class AnimeUnity(CommonResolver):

    def __init__(self, resolver):
        super().__init__(resolver)
        self.ref = None

    def set_request_headers(self):
        ua = self.resolver.cli.get_random_ua()
        self.request_headers = {
            "user-agent": ua
        }

    def find_stream(self):
        matches = re.compile(r"embed_url=\"([^\"]+)\"", re.DOTALL).findall(self.page_src)

        if matches:
            url = matches[0].replace('&amp;', '&')
            r = self.resolver.cli.get_request(url,
                                              headers={'referer': self.resolver.find_hostname(
                                                  self.resolver.start_url) + "/"})

            ms = re.compile(r"window.masterPlaylist = ({.*?params:.*?{.*?},.*?})", re.DOTALL).findall(r.text)

            self.ref = r.url
            if ms:
                masterplaylist = ms[0]
                mediaurl = re.compile(r"url: '([^']+)'", re.MULTILINE).findall(masterplaylist)[0]
                mediaurl += "?"
                ps = re.compile(r".*?'([^']+)':.*?'(.*?)'(?:,|$)", re.MULTILINE | re.DOTALL).findall(masterplaylist)
                for p in ps:
                    k, v = p
                    mediaurl += k + "=" + v + "&"
                mediaurl = mediaurl.rstrip("&") + "&h=1"
                # mediaurl += "&b=1" if quality == "720" else "&h=1"

                return [mediaurl]

            return []

    def set_referer(self, url):
        return "!Referer=" + quote_plus(self.ref) + "&User-Agent=" + self.resolver.cli.headers[
            "user-agent"] + "&force_isaf=1&isaf_rts=false"
