import re
from conf.common import CommonResolver


class DaddyHd(CommonResolver):

    def __init__(self, resolver):
        super().__init__(resolver)
        self.ref = None

    def find_page(self):
        return [r'iframe src="(.*?)" width']

    def find_stream(self):
        matches = re.compile(r'iframe src="(.*?)" width', re.MULTILINE).findall(self.page_src)
        if matches:
            ref = matches[0]
            page_src = self.resolver.cli.get_request(ref)
            iframe = re.compile(r'<iframe.*?src=\"([^\"]+)\"', re.MULTILINE).findall(page_src.text)
            if iframe:
                iframe_src = self.resolver.cli.get_request(iframe[0], headers={'sec-fetch-dest': 'iframe'})
                iframe = re.compile(r'<iframe.*?src=\"([^\"]+)\"', re.MULTILINE).findall(iframe_src.text)
                ref = self.resolver.find_hostname(iframe[0].strip())
                iframe_src = self.resolver.cli.get_request(iframe[0].strip(), headers={'sec-fetch-dest': 'iframe'})
                iframe = re.compile(r'<iframe.*?src=\"([^\"]+)\"', re.MULTILINE).findall(iframe_src.text)
                dhd = self.resolver.cli.get_request(iframe[0].strip(), headers={'sec-fetch-dest': 'iframe', 'Referer': ref})
                self.ref = self.resolver.find_hostname(dhd.url)
                stream = re.compile('source:\'(.*)\'').findall(dhd.text)[-1]

                return [stream]

        return []

    def set_referer(self, url):
        ua = self.resolver.cli.headers["user-agent"]
        return "!Referer=" + self.ref + "/" + "&Origin=" + self.ref + "&User-Agent=" + ua + "&force_isaf=1"
