import re

from conf.common import CommonResolver
from jsbeautifier.unpackers import packer


class Enigma4k(CommonResolver):

    def __init__(self, resolver):
        super().__init__(resolver)
        self.ref = None

    def find_stream(self):
        id_url = re.compile(r'http.*?\?id=(\d+)').findall(self.page_url)[0]
        req2 = self.resolver.cli.get_request(
            self.resolver.find_hostname(self.page_url) + '/get_video_link.php?id=' + id_url)

        url3 = re.compile(r'.*?:.*?"([^"]+)"').findall(req2.text)[0]

        req3 = self.resolver.cli.get_request(url3.replace("\\", ""))

        url4 = re.compile(r"<iframe.*?src='([^']+)'").findall(req3.text)[0]

        req4 = self.resolver.cli.get_request(url4)
        url5 = re.compile(r'<iframe.*?src="([^"]+)"').findall(req4.text)[0]

        req6 = self.resolver.cli.get_request('https:' + url5, headers={'Referer': self.resolver.find_hostname(url4)})
        self.ref = req6.url
        packed_src = re.compile(r'<script>(eval\(function\(p,a,c,k,e,d\){.*?)\s+</script>', re.MULTILINE | re.S).findall(req6.text)[0]

        unpacked_src = packer.unpack(packed_src)

        stream = re.compile(r'var src="([^"]+)"').findall(unpacked_src)[0]

        return [stream]

    def set_referer(self, url):
        ref = self.resolver.find_hostname(self.ref)
        return "!Referer=" + ref + "/&Origin=" + ref + "&user-agent=" + self.resolver.cli.headers["user-agent"]
