import re
from jsbeautifier.unpackers import packer

from conf.common import CommonResolver


class SportsOnline(CommonResolver):

    def __init__(self, resolver):
        super().__init__(resolver)
        self.ref = None

    def find_stream(self):
        iframe = re.compile(r'<iframe.*?src=\"([^\"]+)\" width', re.MULTILINE).findall(self.page_src)
        iframe_url = iframe[0]
        if iframe_url.startswith("//"):
            iframe_url = "https:" + iframe_url
        res = self.resolver.cli.get_request(iframe_url)
        self.ref = res.url
        packed_src = re.compile(r'<script>.*?(eval\(function\(p,a,c,k,e,d\).*?)</script>', re.DOTALL).findall(res.text)
        unpacked_src = packer.unpack(packed_src[1])
        stream = re.compile(r'src=\"([^\"]+)\"', re.MULTILINE).findall(unpacked_src)

        ret = []
        for i, s in enumerate(stream):
            ret.append(("Link " + str(i + 1), s))

        return ret

    def set_referer(self, url):
        ref_host = re.compile(r'(http.*?//.*?/)').findall(self.ref)[0]
        ua = self.resolver.cli.headers["user-agent"]
        return "!Referer=" + ref_host + "&Origin=" + ref_host[:-1] + "&User-Agent=" + ua
