import re
from urllib.parse import quote_plus

from conf.common import CommonResolver


class StreamCommunity(CommonResolver):
    def __init__(self, resolver):
        super().__init__(resolver)
        self.use_last_domain = True
        self.ref = ''

    def find_stream(self):

        iframe_url = re.compile(r'<div id=\"app\" data-page=\".*?embedUrl.*?;(http.*?)&quot;', re.MULTILINE | re.DOTALL).findall(
            self.page_src)

        if iframe_url:
            self.page_url = iframe_url[0].replace('&amp;', '&')

        page_src = self.resolver.cli.get_request(self.page_url)
        matches = re.compile(r'ref="iframe".*?src="([^"]+)"', re.MULTILINE | re.DOTALL).findall(page_src.text)
        if matches:
            url = matches[0].replace('&amp;', '&')
            r = self.resolver.cli.get_request(url,
                                              headers={'referer': self.resolver.find_hostname(
                                                  self.page_url) + "/"})

            ms = re.compile(r"window.masterPlaylist = ({.*?params:.*?{.*?},.*?})", re.DOTALL) \
                .findall(r.text)
            self.ref = url

            if ms:
                masterplaylist = ms[0]
                mediaurl = re.compile(r"url: '([^']+)'", re.MULTILINE).findall(masterplaylist)[0]
                if "?" not in mediaurl:
                    mediaurl += "?"
                else:
                    mediaurl += "&"
                ps = re.compile(r".*?'([^']+)':.*?'(.*?)'(?:,|$)", re.MULTILINE | re.DOTALL).findall(masterplaylist)
                for p in ps:
                    k, v = p
                    if v == "": continue
                    mediaurl += k + "=" + v + "&"
                mediaurl = mediaurl.rstrip("&")

                if "canPlayFHD" in url:
                    mediaurl += "&h=1"
                #else:
                #    mediaurl += "&b=1"

                mediaurl += "&scz=1&lang=it"

                return [mediaurl]

        return []

    def set_referer(self, url):
        return "!Referer=" + quote_plus(self.ref) + "&User-Agent=" + self.resolver.cli.headers["user-agent"] + "&force_isaf=1&isaf_rts=false"
